var activeFlag = false;
var importCode;
var getInfo;
var clipboard;
	
/*jQuery extend func for get element path*/
jQuery.fn.extend({
	getPath: function() {
		var pathes = [];
		var parentId = '';
		this.each(function(index, element) {
			var path, $node = jQuery(element);
			while ($node.length && !parentId) {
				var realNode = $node.get(0), name = realNode.localName;
				if (!name) { break; }
				name = name.toLowerCase();
				var parent = $node.parent();
				if(parent.attr('id')){
					parentId = '#'+parent.attr('id')+' ';
				}
				if(parent.is('[id]')){
					var sel = '#'+parent.attr('id');			
					if($(sel).length == 1 && $(sel).is(parent)){
						parentId = sel+' ';	
					}
				}else{
					if(parent.is('[data-getClass]')){
						var sel = parent.attr('data-getClass');
						sel = '.'+sel.replace(/\s\s+/g, ' ').split(' ').join('.');
						if($(sel).length == 1 && $(sel).is(parent)){
							parentId = sel+' ';		
						}
					}
				}
				var sameTagSiblings = parent.children(name);
				if (sameTagSiblings.length > 1)
				{
					allSiblings = parent.children();
					var index = allSiblings.index(realNode) +1;
					if (index > 0) {
						name += ':nth-child(' + index + ')';
					}
				}
				path = name + (path ? ' > ' + path : '');
				$node = parent;
			}
			pathes.push(path);
		});
		return parentId + pathes.join(',').replace('html > ','');
	}
});

/*Open Gen UI*/
var openGen = function(){
	if (window.jQuery) {
		$('body').attr('data-getPage','');
		$('*[class]').each(function(){
			$(this).attr('data-getClass',$(this).attr('class'));
		});
		
		importCode = $('<div class="getWrap getMin"><div class="getClose">×</div><div class="getHeader"><img class="getLogo" src="'+chrome.extension.getURL("logo.png")+'"><div class="getSub"><span class="getSubIcon">i</span>Right-click on any element, to get his unique selector</div></div><textarea id="getInput" class="getInput"></textarea><div class="getAction"><span data-clipboard-target="#getInput" data-tipcont="Copied" class="getBtn"><span class="getBtnIcon"></span>Copy to clipboard</span></div></div><div class="getShape"></div><div class="getInfo" data-cont="The selector code is ready!"></div>')
		importCode.appendTo('body');
		$('.getWrap').draggable();
		getInfo = $('.getInfo');
		var getShape = $('.getShape');
		var inserValFunc = function(val){
			$('.getInput').val(val);
			getInfo.css({top:event.pageY - 5, left:event.pageX});
			getInfo.attr('data-show','');
			setTimeout(function(){
				getInfo.removeAttr('data-show');
			},1000);
			importCode.removeClass('getMin');
		}
		var checkSelFunc = function(el,sel){
			if($(sel).length == 1 && $(sel).is(el)){
				inserValFunc(sel);	
			}else{
				inserValFunc(el.getPath());	
			}		
		};
		var changeSelect = function(el){
			var offset = el.offset();
			getShape.css({
				width:el.outerWidth(),
				height:el.outerHeight(),
				left:offset.left,
				top:offset.top
			})
		};
		var getPathFunc = function(e){
			var el = $(e.target);
			if(!el.is('.getInput') && !el.is('.getWrap') && !el.is('.getHeader') && !el.is('.getAction') && !el.is('.getBtn') && !el.is('.getBtnIcon') && !el.is('.getShape') && !el.is('.getInfo') && !el.is('.getClose') && !el.is('.getSub') && !el.is('.getSubIcon') && !el.is('.getLogo')){
				changeSelect(el);
				if(el.is('[id]')){
					var sel = '#'+el.attr('id');			
					checkSelFunc(el,sel);
					return false;	
				}
				if(el.is('[data-getClass]')){
					var sel = el.attr('data-getClass');
					sel = '.'+sel.replace(/\s\s+/g, ' ').split(' ').join('.');
					checkSelFunc(el,sel);
					return false;	
				}
				inserValFunc(el.getPath());
			}	
		};	
		var copyCode = $('.getBtn');
		clipboard = new Clipboard('.getBtn');	
		clipboard.on('success', function(e) {
			copyCode.attr('data-tip2','');
			setTimeout(function(){
				copyCode.removeAttr('data-tip2');
			},1000);
			e.clearSelection();
		});
		clipboard.on('error', function(e) {
			console.log(e);
		});
		$(document).on('mouseover.getevent','*',function(event){
			var el = $(event.target);
			if(!el.is('.getWrap') && !el.is('.getWrap *')){
				changeSelect(el);
			}
		});
		$(document).on('contextmenu.getevent','*:not(.getWrap):not(.getWrap *)',function(event){	
			getPathFunc(event);
			event.preventDefault();
			return false;
		});
		$(document).on('mouseenter.getevent','.getWrap',function(){
			changeSelect($('html'));
		});
		$(document).on('click','.getClose',function(){
			activeFlag = false;
			closeGen();	
		});
	}else{
		console.log('jQuery not connected!')	
	}	
};
var closeGen = function(){
	$(document).on('click','.getClose');
	$(document).off('mouseenter.getevent','.getWrap');
	$(document).off('contextmenu.getevent','*:not(.getWrap):not(.getWrap *)');
	$(document).off('mouseover.getevent','*');
	clipboard.off('success');
	clipboard.off('error');
	importCode.remove();	
	$('*[data-getClass]').removeAttr('data-getClass');
	$('body').removeAttr('data-getPage');
};	

/*Get call from browser button*/
chrome.extension.onMessage.addListener(function(msg, sender, sendResponse) {
	if (msg.action == 'open_dialog_box') {
		if(activeFlag == false){
			activeFlag = true;
			openGen();	
		}else{
			activeFlag = false;
			closeGen();	
		}
	}
});
